/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsFileOpenPacket;
import com.ibm.hsc.filesvr.FsFileOpenResponsePacket;
import com.ibm.hsc.filesvr.FsPacket;

public class FsFileOpenRequestPacket
extends FsFileOpenPacket {
    public FsFileOpenRequestPacket(FsConnection fsConnection) {
        super(fsConnection);
        this.setRequestPacket();
    }

    public FsFileOpenRequestPacket(FsConnection fsConnection, int n, String string) {
        super(fsConnection);
        this.setRequestPacket();
        this.m_openAction = 1;
        this.m_fileType = n;
        this.m_fileName = string;
    }

    public FsFileOpenRequestPacket(FsConnection fsConnection, int n, int n2, String string) {
        super(fsConnection);
        this.setRequestPacket();
        this.m_openAction = n;
        this.m_fileType = n2;
        this.m_fileName = string;
    }

    public FsFileOpenRequestPacket(FsPacket fsPacket) {
        super(fsPacket);
        this.setRequestPacket();
    }

    public FsFileOpenRequestPacket(FsPacket fsPacket, int n, int n2, String string) {
        super(fsPacket);
        this.setRequestPacket();
        this.m_openAction = 1;
        this.m_fileType = n2;
        this.m_fileName = string;
    }

    public FsFileOpenRequestPacket(FsFileOpenPacket fsFileOpenPacket) throws FsException {
        super(fsFileOpenPacket);
        this.setRequestPacket();
    }

    public FsFileOpenRequestPacket(FsFileOpenPacket fsFileOpenPacket, int n, String string) {
        super(fsFileOpenPacket);
        this.setRequestPacket();
        this.m_openAction = 1;
        this.m_fileType = n;
        this.m_fileName = string;
    }

    public FsFileOpenRequestPacket(FsFileOpenPacket fsFileOpenPacket, int n, int n2, String string) {
        super(fsFileOpenPacket);
        this.setRequestPacket();
        this.m_openAction = n;
        this.m_fileType = n2;
        this.m_fileName = string;
    }

    public FsFileOpenRequestPacket(FsFileOpenRequestPacket fsFileOpenRequestPacket) throws FsException {
        super(fsFileOpenRequestPacket);
        this.setRequestPacket();
        this.m_openAction = fsFileOpenRequestPacket.m_openAction;
        this.m_fileType = fsFileOpenRequestPacket.m_fileType;
        this.m_fileName = fsFileOpenRequestPacket.m_fileName;
    }

    protected void buildData(FsByteStream fsByteStream) throws FsException {
        super.buildData(fsByteStream);
        this.validate();
        fsByteStream.writeInt(this.m_openAction);
        fsByteStream.writeInt(this.m_fileType);
        fsByteStream.writeLong(this.m_fileName.length());
        fsByteStream.writeString(this.m_fileName);
    }

    public FsPacket getResponsePacket() {
        return new FsFileOpenResponsePacket(this);
    }

    protected void parseData(FsByteStream fsByteStream) throws FsException {
        super.parseData(fsByteStream);
        if (!this.isRequestPacket()) {
            throw new FsException(20);
        }
        this.m_openAction = fsByteStream.readInt();
        this.m_fileType = fsByteStream.readInt();
        int n = (int)fsByteStream.readLong();
        this.m_fileName = fsByteStream.readString(n);
        this.validate();
    }

    private void validate() throws FsException {
        if (!this.isRequestPacket()) {
            throw new FsException(20);
        }
        if (this.m_fileName == null) {
            throw new FsException(21);
        }
        if (this.m_openAction != 1) {
            throw new FsException(28, this.m_openAction);
        }
        if (this.m_fileType != 1) {
            throw new FsException(23, this.m_fileType);
        }
    }
}

